/*
 * Decompiled with CFR 0.152.
 */
package com.garantis.polarion.widget;

import com.polarion.alm.shared.api.model.ModelObject;
import com.polarion.alm.shared.api.model.ModelObjectsSearch;
import com.polarion.alm.shared.api.model.baseline.Baseline;
import com.polarion.alm.shared.api.model.revision.Revision;
import com.polarion.alm.shared.api.model.rp.parameter.CompositeParameter;
import com.polarion.alm.shared.api.model.rp.parameter.RichPageParameter;
import com.polarion.alm.shared.api.model.rp.parameter.StringParameter;
import com.polarion.alm.shared.api.model.rp.parameter.impl.dataset.ScopeParameterImpl;
import com.polarion.alm.shared.api.model.rp.parameter.impl.enumeration.CustomEnumParameterImpl;
import com.polarion.alm.shared.api.model.rp.widget.RichPageWidgetRenderingContext;
import com.polarion.alm.shared.api.model.user.User;
import com.polarion.alm.shared.api.utils.html.HtmlFragmentBuilder;
import com.polarion.alm.shared.api.utils.html.HtmlTagBuilder;
import com.polarion.alm.shared.api.utils.links.HtmlLink;
import com.polarion.alm.shared.api.utils.links.HtmlLinkFactory;
import com.polarion.alm.tracker.ITrackerService;
import com.polarion.platform.core.PlatformContext;
import com.polarion.platform.persistence.model.IPObject;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class WidgetBaselinesRender {
    private final RichPageWidgetRenderingContext context;
    private String warningMessage;
    private String scopeId;
    private String baselineType;
    private String tableStyle;
    private String headerCellStyle;
    private String rowCellStyle;

    WidgetBaselinesRender(@NotNull RichPageWidgetRenderingContext context) {
        this.context = context;
        this.scopeId = this.getScopeParameterValue("scope");
        this.baselineType = this.getTypeParameterSingleValue("baselineType");
        CompositeParameter advanced = (CompositeParameter)context.parameter("advanced");
        this.tableStyle = this.getStringParameterValue(advanced, "tableStyle");
        this.headerCellStyle = this.getStringParameterValue(advanced, "tableHeaderCellStyle");
        this.rowCellStyle = this.getStringParameterValue(advanced, "tableRowCellStyle");
    }

    private ModelObjectsSearch<Baseline> getTransactionBaseLines(@NotNull String projectId) {
        return this.context.transaction().baselines().search().query("project.id:" + projectId).sort("~id");
    }

    private String getTypeParameterSingleValue(@NotNull String parameterId) {
        CustomEnumParameterImpl parameter = (CustomEnumParameterImpl)this.context.parameter(parameterId);
        String value = parameter.singleValue();
        if (value == null) {
            value = "";
        }
        return value;
    }

    @NotNull
    private String getScopeParameterValue(@NotNull String parameterId) {
        ScopeParameterImpl parameter = (ScopeParameterImpl)this.context.parameter(parameterId);
        String value = parameter.scope().projectId();
        if (value == null) {
            this.setWarningMessage((RichPageParameter)parameter);
        }
        return value;
    }

    @NotNull
    private String getStringParameterValue(@NotNull CompositeParameter advanced, @NotNull String parameterId) {
        StringParameter stringParameter = (StringParameter)advanced.get(parameterId);
        String value = stringParameter.value();
        return value == null ? "" : value;
    }

    private void setWarningMessage(@NotNull RichPageParameter parameter) {
        this.warningMessage = "Parameter " + parameter.label() + " is required";
    }

    private ArrayList<Baseline> filterBaselinesArrayForType(String query) {
        ModelObjectsSearch baselines = this.context.transaction().baselines().search().query("project.id:" + this.scopeId).sort("~id");
        if (this.baselineType == "") {
            return baselines.toArrayList();
        }
        ArrayList<Baseline> tempArray = new ArrayList<Baseline>();
        for (Baseline baseline : baselines) {
            if (baseline.isUnresolvable() || !this.baselineType.contains(((ModelObject)baseline.fields().baseObject().get()).getOldApi().getLocalId().getPrototypeName())) continue;
            tempArray.add(baseline);
        }
        return tempArray;
    }

    public String render() {
        HtmlFragmentBuilder builder = this.context.createHtmlFragmentBuilder();
        if (this.warningMessage != null) {
            return this.context.renderWarning(this.warningMessage);
        }
        this.appendLinkLine(builder);
        ArrayList<Baseline> baselines = this.filterBaselinesArrayForType("project.id:" + this.scopeId);
        if (baselines.size() > 0) {
            HtmlTagBuilder table = (HtmlTagBuilder)builder.tag().table();
            table.attributes().style(this.tableStyle);
            this.appendHeaderTable(table);
            this.appendRowsTable(table, baselines);
            return builder.toString();
        }
        return this.context.renderWarning("Baselines not found.");
    }

    private void appendLinkLine(@NotNull HtmlFragmentBuilder builder) {
        String httpProject = this.context.transaction().context().createPortalLink().project(this.scopeId).toEncodedAbsoluteUrl();
        HtmlTagBuilder p = (HtmlTagBuilder)builder.tag().p();
        p.append().text("Quick Link: ");
        HtmlTagBuilder i = (HtmlTagBuilder)p.append().tag().i();
        HtmlTagBuilder a = (HtmlTagBuilder)i.append().tag().a();
        Object factory = null;
        HtmlLink link = HtmlLinkFactory.fromEncodedUrl((String)(String.valueOf(httpProject) + "/baselines"));
        a.attributes().href(link).target("_blank");
        a.append().text("Baselines - standard Polarion report page");
        p.append().text(" - to ");
        HtmlTagBuilder b1 = (HtmlTagBuilder)p.append().tag().b();
        b1.append().text("view");
        p.append().text(" existing and ");
        HtmlTagBuilder b2 = (HtmlTagBuilder)p.append().tag().b();
        b2.append().text("create");
        p.append().text(" new baselines.");
    }

    private void appendHeaderTable(@NotNull HtmlTagBuilder table) {
        HtmlTagBuilder tr = (HtmlTagBuilder)table.append().tag().tr();
        HtmlTagBuilder th1 = (HtmlTagBuilder)tr.append().tag().th();
        th1.attributes().style(this.headerCellStyle);
        th1.append().text("#");
        HtmlTagBuilder th2 = (HtmlTagBuilder)tr.append().tag().th();
        th2.attributes().style(this.headerCellStyle);
        th2.append().text("Name");
        HtmlTagBuilder th3 = (HtmlTagBuilder)tr.append().tag().th();
        th3.attributes().style(this.headerCellStyle);
        th3.append().text("Revision");
        HtmlTagBuilder th4 = (HtmlTagBuilder)tr.append().tag().th();
        th4.attributes().style(this.headerCellStyle);
        th4.append().text("Author");
        HtmlTagBuilder th5 = (HtmlTagBuilder)tr.append().tag().th();
        th5.attributes().style(this.headerCellStyle);
        th5.append().text("Created date");
        HtmlTagBuilder th6 = (HtmlTagBuilder)tr.append().tag().th();
        th6.attributes().style(this.headerCellStyle);
        th6.append().text("Updated date");
        HtmlTagBuilder th7 = (HtmlTagBuilder)tr.append().tag().th();
        th7.attributes().style(this.headerCellStyle);
        th7.append().text("Description");
        HtmlTagBuilder th8 = (HtmlTagBuilder)tr.append().tag().th();
        th8.attributes().style(this.headerCellStyle);
        th8.append().text("Type");
    }

    private void appendRowsTable(@NotNull HtmlTagBuilder table, @NotNull ArrayList<Baseline> baselines) {
        int count = 0;
        for (Baseline baseline : baselines) {
            if (baseline.isUnresolvable()) continue;
            HtmlTagBuilder tr = (HtmlTagBuilder)table.append().tag().tr();
            HtmlTagBuilder td = (HtmlTagBuilder)tr.append().tag().td();
            td.attributes().style(this.rowCellStyle);
            td.append().text("" + ++count);
            HtmlTagBuilder tdName = (HtmlTagBuilder)tr.append().tag().td();
            tdName.attributes().style(this.rowCellStyle);
            String httpProject = this.context.transaction().context().createPortalLink().baseline(baseline.fields().baseRevision().get()).project(this.scopeId).toEncodedAbsoluteUrl();
            HtmlTagBuilder a = (HtmlTagBuilder)tdName.append().tag().a();
            Object factory = null;
            HtmlLink link = HtmlLinkFactory.fromEncodedUrl((String)(String.valueOf(httpProject) + "/home"));
            a.attributes().href(link).target("_blank");
            a.append().text(baseline.fields().name().get());
            HtmlTagBuilder tdRevision = (HtmlTagBuilder)tr.append().tag().td();
            tdRevision.attributes().style(this.rowCellStyle);
            tdRevision.append().text(baseline.fields().baseRevision().get());
            HtmlTagBuilder tdAuthor = (HtmlTagBuilder)tr.append().tag().td();
            tdAuthor.attributes().style(this.rowCellStyle);
            tdAuthor.append().text(((User)this.context.transaction().users().getBy().id(baseline.fields().author().userId())).fields().name().get());
            HtmlTagBuilder tdDate = (HtmlTagBuilder)tr.append().tag().td();
            tdDate.attributes().style(this.rowCellStyle);
            ITrackerService trackerService = (ITrackerService)PlatformContext.getPlatform().lookupService(ITrackerService.class);
            String baselineCreatDataRev = ((IPObject)trackerService.getDataService().getObjectHistory(baseline.getOldApi()).get(0)).getRevision();
            ((Revision)this.context.transaction().revisions().getBy().id(baselineCreatDataRev)).fields().created().render().htmlTo(tdDate.append());
            HtmlTagBuilder tdUpdate = (HtmlTagBuilder)tr.append().tag().td();
            tdUpdate.attributes().style(this.rowCellStyle);
            String baselineUpdateDataRev = baseline.getOldApi().getLastRevision();
            ((Revision)this.context.transaction().revisions().getBy().id(baselineUpdateDataRev)).fields().created().render().htmlTo(tdUpdate.append());
            HtmlTagBuilder tdDesc = (HtmlTagBuilder)tr.append().tag().td();
            tdDesc.attributes().style(this.rowCellStyle);
            baseline.fields().description().render().htmlTo(tdDesc.append());
            HtmlTagBuilder tdType = (HtmlTagBuilder)tr.append().tag().td();
            tdType.attributes().style(this.rowCellStyle);
            HtmlTagBuilder b = (HtmlTagBuilder)tdType.append().tag().b();
            b.attributes().style("color:#A9A9A9;");
            String BaselineType = ((ModelObject)baseline.fields().baseObject().get()).getOldApi().getLocalId().getPrototypeName();
            b.append().text(BaselineType.contains("Module") ? "Document" : BaselineType);
        }
    }
}

